package ga.view.streaming.nodes;

import ga.core.individual.IIndividual;

/**
 * Listener that receives callback events aboud the panel node.
 * 
 * @param <T>
 *          The generic type of the individuals.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public interface PanelNodeListener<T extends IIndividual<T>> {

  /**
   * This is called when the panel is ready to destroy.
   * 
   * @param panelNode
   *          the panel node
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public void panelReadyToDestroy(PanelNode<T> panelNode);

  /**
   * This is called when the panel is in inspect position.
   * 
   * @param panelNode
   *          the panel node
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public void panelInInspectPosition(PanelNode<T> panelNode);
}
